### 一张图搞懂dex

[大图这里](https://box.kancloud.cn/a60feaef41587bfe91f3bb1a10be6bd0_4287x1818.jpg)
![img](https://box.kancloud.cn/a60feaef41587bfe91f3bb1a10be6bd0_4287x1818.jpg)

 

当然也可以通过下面的图12 DexFile的文件格式，了解更清楚。

##### 1.1.1DEX文件详解

> - 什么是dex文件？
> - 如何生成一个dex文件
> - dex文件的作用
> - dex文件格式详解

##### 1.1.2 什么是dex文件？

​		dex文件是Android系统中的一种文件，是一种特殊的数据格式，和APK、jar 等格式文件类似。
能够被**Android虚拟机识别，加载并执行的文件格式**。
​		简单说就是优化后的android版.exe。每个apk安装包里都有。包含应用程序的全部操作指令以及运行时数据。
相对于PC上的java虚拟机能运行.class；android上的Davlik虚拟机能运行.dex。

​		当java程序编译成class后，还需要使用dx工具将所有的class文件整合到一个dex文件，目的是其中各个类能够共享数据，在一定程度上降低了冗余，同时也是文件结构更加经凑，实验表明，dex文件是**传统jar文件大小的50%**左右
![img](https://box.kancloud.cn/9825f74b154c260a54c987ef417a15dc_604x514.png)

 

为何要研究dex格式？因为dex里面包含了所有app代码，利用反编译工具可以获取java源码。理解并修改dex文件，就能更好的apk破解和防破解。

使用dex文件的最大目的是实现安全管理，但在追求安全的前提下，一定要注意对dex文件实现优化处理。

> 注意：并不是只有Java才可以生成dex文件，C和C++也可以生成dex文件

##### 1.1.3 如何生成一个dex文件？

1. 通过IDE自动帮我们build生成

   > 新建一个Caclutor.java

   ```
   package com.maniu.maniufix;
   
   public class Caclutor {
       public Caclutor() {
       }
   
       public int caculator() {
           int i = 0;
           int j = 10;
           return j / i;
       }
   
       public static void main(String[] arg) {
           System.out.println("hello  dex");
       }
   }
   
   ```

   

2. 手动通过dx命令去生成dex文件

   > 将编译好的 Caclutor.class 放到包名对应的文件夹  如:com\maniu\maniufix

   **执行**

   ```
   dx --dex --output C:\Users\Administrator\Desktop\Class类\main.dex C:\Users\Administrator\Desktop\Class类\dx
   ```

   

   在待测试的class文件目录下（我将Caclutor.class放到了F盘根目录下）

   执行命令

   ```
    dalvikvm -cp /sdcard/main.dex  com.maniu.maniufix.Caclutor
   ```

   就会生成TestMain.dex文件。

3. 手动运行dex文件在手机
   在待测试的dex文件目录下（我将TestMain.class放到了F盘根目录下），通过`adb push TestMain.dex /storage/emulated/0`命令，然后通过`adb shell`命令进入手机，后执行`dalvikvm -cp /sdcard/TestMain.dex TestMain`，就会打印出

```
Hello World!
```

如下图3所示（使用AS的终端，没有用Windows的cmd命令）
![img](https://box.kancloud.cn/e702670e8c32e4c2137e06404bb94e29_686x247.jpg)

图3 手动运行dex文件

注意：

- 环境变量的配置，dex在SDK目录下的build-tools目录下有很多版本，这里可以选择最新版本目录下dx.bat配置到环境变量path路径下；同样，adb命令也同样配置。
- 运行完dex文件，可以通过exit退出手机，电脑本地盘符

#### 查看dex文件